using System;
using System.Collections.Generic;
using Top.Api.Util;

namespace Top.Api.Request
{
    /// <summary>
    /// TOP API: taobao.openmall.trade.get
    /// </summary>
    public class OpenmallTradeGetRequest : BaseTopRequest<Top.Api.Response.OpenmallTradeGetResponse>
    {
        /// <summary>
        /// 分销者信息
        /// </summary>
        public string Distributor { get; set; }

        /// <summary>
        /// 淘宝订单号
        /// </summary>
        public Nullable<long> Tid { get; set; }

        #region ITopRequest Members

        public override string GetApiName()
        {
            return "taobao.openmall.trade.get";
        }

        public override IDictionary<string, string> GetParameters()
        {
            TopDictionary parameters = new TopDictionary();
            parameters.Add("distributor", this.Distributor);
            parameters.Add("tid", this.Tid);
            if (this.otherParams != null)
            {
                parameters.AddAll(this.otherParams);
            }
            return parameters;
        }

        public override void Validate()
        {
            RequestValidator.ValidateRequired("distributor", this.Distributor);
            RequestValidator.ValidateRequired("tid", this.Tid);
        }

        #endregion
    }
}
