using System;
using System.Xml.Serialization;
using System.Collections.Generic;
using Top.Api.Util;
using Top.Api;
using Top.Api.DingTalk;

namespace DingTalk.Api.Request
{
    /// <summary>
    /// TOP API: dingtalk.oapi.collection.form.delete
    /// </summary>
    public class OapiCollectionFormDeleteRequest : BaseDingTalkRequest<DingTalk.Api.Response.OapiCollectionFormDeleteResponse>
    {
        /// <summary>
        /// 根请求
        /// </summary>
        public string Request { get; set; }

        public FormSchemaDeleteRequestDomain Request_ { set { this.Request = TopUtils.ObjectToJson(value); } } 

        #region IDingTalkRequest Members

        public override string GetApiName()
        {
            return "dingtalk.oapi.collection.form.delete";
        }

        public override string GetApiCallType()
        {
            return DingTalkConstants.CALL_TYPE_OAPI;
        }

        public override IDictionary<string, string> GetParameters()
        {
            TopDictionary parameters = new TopDictionary();
            parameters.Add("request", this.Request);
            if (this.otherParams != null)
            {
                parameters.AddAll(this.otherParams);
            }
            return parameters;
        }

        public override void Validate()
        {
            RequestValidator.ValidateRequired("request", this.Request);
        }

	/// <summary>
/// FormSchemaDeleteRequestDomain Data Structure.
/// </summary>
[Serializable]

public class FormSchemaDeleteRequestDomain : TopObject
{
	        /// <summary>
	        /// bizType
	        /// </summary>
	        [XmlElement("biz_type")]
	        public Nullable<long> BizType { get; set; }
	
	        /// <summary>
	        /// 表单code
	        /// </summary>
	        [XmlElement("form_code")]
	        public string FormCode { get; set; }
	
	        /// <summary>
	        /// 用户id
	        /// </summary>
	        [XmlElement("userid")]
	        public string Userid { get; set; }
}

        #endregion
    }
}
